/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.erb.html;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CompositeSourceViewerConfiguration;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.erb.ERBEditorPlugin;
import com.aptana.editor.erb.ERBPartitionerSwitchStrategy;
import com.aptana.editor.erb.IERBConstants;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.ruby.RubySourceConfiguration;
import com.aptana.editor.ruby.core.RubyDoubleClickStrategy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class RHTMLSourceViewerConfiguration
extends CompositeSourceViewerConfiguration
implements IERBConstants {
    private RubyDoubleClickStrategy fDoubleClickStrategy;

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html.erb"}), new QualifiedContentType(new String[]{"text.html.ruby"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html.erb", "__common_start_switch_tag"}), new QualifiedContentType(new String[]{"text.html.ruby", "source.erb.embedded.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html.erb", "__common_end_switch_tag"}), new QualifiedContentType(new String[]{"text.html.ruby", "source.erb.embedded.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html.erb", "com.aptana.contenttype.html"}), new QualifiedContentType(new String[]{"text.html.ruby"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html.erb", "com.aptana.contenttype.css"}), new QualifiedContentType(new String[]{"text.html.ruby", "source.css.embedded.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html.erb", "com.aptana.contenttype.js"}), new QualifiedContentType(new String[]{"text.html.ruby", "source.js.embedded.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html.erb", "com.aptana.contenttype.ruby"}), new QualifiedContentType(new String[]{"text.html.ruby", "source.ruby.rails.embedded.html"}));
    }

    protected RHTMLSourceViewerConfiguration(IPreferenceStore preferences, AbstractThemeableEditor editor) {
        super((ISourceViewerConfiguration)HTMLSourceConfiguration.getDefault(), (ISourceViewerConfiguration)RubySourceConfiguration.getDefault(), preferences, editor);
    }

    protected String getTopContentType() {
        return "com.aptana.contenttype.html.erb";
    }

    protected IPartitionerSwitchStrategy getPartitionerSwitchStrategy() {
        return ERBPartitionerSwitchStrategy.getDefault();
    }

    protected String getStartEndTokenType() {
        return "punctuation.section.embedded.ruby";
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new RubyDoubleClickStrategy();
        }
        return this.fDoubleClickStrategy;
    }

    protected IContentAssistProcessor getContentAssistProcessor(ISourceViewer sourceViewer, String contentType) {
        return HTMLSourceConfiguration.getDefault().getContentAssistProcessor(this.getEditor(), contentType);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new RubyRegexpAutoIndentStrategy(contentType, (SourceViewerConfiguration)this, sourceViewer, ERBEditorPlugin.getDefault().getPreferenceStore())};
    }
}

